//select directory of images to open
input = getDirectory("Input directory where images are stored");

//select location where images/results are to be stored
output = getDirectory("Output ditrectory for results");

//gets list of files
list = getFileList(input);
run("Clear Results");
//loop for opening images
for (image=0;image<list.length;image++){
full = input +  list[image];
run("Bio-Formats Importer", "open=full autoscale color_mode=Composite view=Hyperstack stack_order=XYCZT");

fn=getTitle();
roiManager("reset");
run("Select None");

run("Duplicate...", "title=Mask duplicate channels=1");
run("Gamma...", "value=0.50");
run("Smooth");

run("Subtract Background...", "rolling=50");
setAutoThreshold("Huang dark");
run("Threshold...");

setThreshold(6000, 65535); //threshold levels to adapt to antibodies
waitForUser("checkthreshold");

run("Create Selection");
roiManager("Add");
selectWindow("Mask");
close();

selectWindow(fn); 
run("Duplicate...", "title=["+fn+" green] duplicate channels=1");
roiManager("Select", 0);
roiManager("Measure");

//save drawing or image
out = output + fn + " Overlay";
saveAs("Tiff",out);
run("Close All");



}
//save results file
out = output + " measurements.xls";
saveAs("Results",out);


